#!/bin/bash
#SBATCH --job-name=MNIST-DDPM # name of the job
#SBATCH -p gpu-unlimited # which partition the job should be scheduled on
#SBATCH --output=./slurm_logs/MNIST-DDPM-%j.out
#SBATCH --error=./slurm_logs/MNIST-DDPM-%j.err
#__SBATCH --nodes=4
#__SBATCH --tasks-per-node=8
##__SBATCH -w gpu[29,30,31,33]
##__SBATCH --mem=3000
##__SBATCH -N 5
##__SBATCH -a 0-120%3

dt=$(date '+%d/%m/%Y %H:%M:%S');
echo $dt # debugging datetime print

## train single diffusion model
python3 mnist__conditional_diffusion.py --set_id $1 --n_epoch 150

## train single diffusion model with number of zeros reduced to 1%
##python3 mnist__conditional_diffusion.py --set_id $1 --n_epoch 150 --zero_frac 0.01

dt=$(date '+%d/%m/%Y %H:%M:%S');
echo $dt # debugging datetime print
